package gov.va.med.mhv.usermgmt.service.handler;

import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.config.ConfigurationManager;

/**
 * 
 *
 */
public class MviProperties {

	private static final Log LOG = LogFactory.getLog(MviProperties.class);
	private static final String RESOURCE_NAME = "/mvi.properties";
	//private static final Properties properties = ConfigurationManager.getConfiguration("/mvi.properties");
	
	private static MviProperties INSTANCE = new MviProperties();

	private final Boolean isMviEnabled;
	private final Boolean isReloadRequired;
	private final String mviEnvType;
	private final String mviDevWsdlurl;
	private final String mviIntbWsdlurl;
	private final String mviSysTestWsdlurl;
	private final String mviPreProdWsdlurl;
	private final String mviProdWsdlurl;
	private final Integer mviConnectTimeout;
	private final Integer mviRequestTimeout;
	private final Boolean isMviMockSearchEnabled;
	private final Boolean isMviMockCorrespondingEnabled;
	private final Boolean isMviMockCorrelationEnabled;
	private final Boolean isMviMockSearchByEdipiEnabled;
	
	private final String mviInteractionId;
	private final String vaOidValue;
	private final String mviRootId;
	private final String mviReceivingFacilityId;
	private final String mviUsssaIdentifierId;
	private final String mviFacilityAssignAuthority;
	private final String mviPatientIdentifier;
	private final String mviNationalIdentifier;
	private final String mviEdipiIdentifier;
	//private final Integer mviAuthBatchNumberToRun;
	//private final Integer mviUnauthBatchNumberToRun;
	//private final String mviAuthBatchAdmin;
	//private final Integer mviAuthBatchIntervalHours;
	
	private final String mviProdDodrootId;
	private final String mviNonprodDodrootId;
	
	private final String dodAssigningAuthority;
	private final String dodFacilityAssigning;
	
	public static MviProperties getInstance() {
		Properties properties = ConfigurationManager.getConfiguration(RESOURCE_NAME);
		boolean reloadCheck = Boolean.parseBoolean(properties.getProperty("mvi.property.reload","false"));
		if(reloadCheck) {
			INSTANCE = new MviProperties();
			return INSTANCE;
		}
		else
			return INSTANCE;
		//return (reloadCheck) ? new MviProperties() : INSTANCE;
	}
	public static MviProperties reInstance() {
		INSTANCE = new MviProperties();
		return INSTANCE;
	}

	private MviProperties() {
		Properties properties = ConfigurationManager.getConfiguration(RESOURCE_NAME);
		isMviEnabled 					= (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.enabled")) : true;
		isReloadRequired				= (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.property.reload")) : false; 
		isMviMockSearchEnabled 			= (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.mock.search.enabled")) : false;
		isMviMockCorrespondingEnabled	= (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.mock.getcorrespond.enabled")) : false;
		isMviMockCorrelationEnabled		= (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.mock.correlation.enabled")) : false;
		isMviMockSearchByEdipiEnabled   = (properties != null) ? Boolean.parseBoolean(properties.getProperty("mvi.mock.searchbyedipi.enabled")) : false;
		
		mviEnvType						= (properties != null) ? (properties.getProperty("mvi.env.type")) : "";
		mviDevWsdlurl					= (properties != null) ? (properties.getProperty("mvi.dev.wsdlurl")) : "";
		mviIntbWsdlurl					= (properties != null) ? (properties.getProperty("mvi.intb.wsdlurl")) : "";
		mviSysTestWsdlurl  				= (properties != null) ? (properties.getProperty("mvi.systest.wsdlurl")) : "";
		mviPreProdWsdlurl				= (properties != null) ? (properties.getProperty("mvi.preprod.wsdlurl")) : "";
		mviProdWsdlurl					= (properties != null) ? (properties.getProperty("mvi.prod.wsdlurl")) : "";

		mviConnectTimeout				= (properties != null) ? Integer.parseInt((properties.getProperty("mvi.connect.timeout"))) : 60;
		mviRequestTimeout				= (properties != null) ? Integer.parseInt((properties.getProperty("mvi.request.timeout"))) : 180;
	
		mviInteractionId				= (properties != null) ? (properties.getProperty("mvi.interaction.id")) : "";
		vaOidValue						= (properties != null) ? (properties.getProperty("va.oid.value")) : "2.16.840.1.113883.4.349";
		mviRootId						= (properties != null) ? (properties.getProperty("mvi.root.id")) : "2.16.840.1.113883.3.933";
		mviUsssaIdentifierId			= (properties != null) ? (properties.getProperty("mvi.usssa.identifier.id")) : "2.16.840.1.113883.4.1";
		
		mviReceivingFacilityId			= (properties != null) ? (properties.getProperty("mvi.receiving.facility")) : "200MH";
		mviFacilityAssignAuthority 		= (properties != null) ? (properties.getProperty("facility.assigning.authority")) : "USVHA";
		mviPatientIdentifier			= (properties != null) ? (properties.getProperty("mvi.patient.identifier")) : "PI";
		mviNationalIdentifier			= (properties != null) ? (properties.getProperty("mvi.national.identifier")) : "NI";
		mviEdipiIdentifier				= (properties != null) ? (properties.getProperty("mvi.edipi.identifier")) : "DOD";
//		mviAuthBatchNumberToRun			= (properties != null) ? new Integer((properties.getProperty("mvi.auth.batch.number.to.run").toString())) : 30;
//		mviUnauthBatchNumberToRun		= (properties != null) ? new Integer((properties.getProperty("mvi.unauth.batch.number.to.run").toString())) : 30;
//		mviAuthBatchAdmin				= (properties != null) ? (properties.getProperty("mvi.auth.batch.admin")) : "";
//		mviAuthBatchIntervalHours   	= (properties != null) ? new Integer((properties.getProperty("mvi.auth.batch.interval.hour").toString())) : 24;
		mviProdDodrootId				= (properties != null) ? (properties.getProperty("mvi.prod.dodroot.id")) : "2.16.840.1.113883.3.42.10001.100001.12";
		mviNonprodDodrootId				= (properties != null) ? (properties.getProperty("mvi.nonprod.dodroot.id")) : "2.16.840.1.113883.3.364"; 
		
		dodFacilityAssigning			= (properties != null) ? (properties.getProperty("dod.facility.assigning")) : "200DOD";
		dodAssigningAuthority			= (properties != null) ? (properties.getProperty("dod.assigning.authority")) : "USDOD";
		
		
		if (LOG.isInfoEnabled()) {
			LOG.info("Using the Following MVI Properties: " + describe());
		}
	}

	public String describe() {
		StringBuilder builder = new StringBuilder();
		builder.append("\nMviProperties[");
		builder.append(" \nmvi.enabled=").append(isMviEnabled);
		builder.append(" \nChosen ENVIRONMENT=").append(mviEnvType);
		builder.append(" \nmvi.mock.search.enabled=").append(isMviMockSearchEnabled);
		builder.append(" \nmvi.mock.getcorrespond.enabled=").append(isMviMockCorrespondingEnabled);
		builder.append(" \nmvi.mock.correlation.enabled=").append(isMviMockCorrelationEnabled);
		builder.append(" \nmviDevWsdlurl=").append(mviDevWsdlurl);
		builder.append(" \nmviTestWsdlurl=").append(mviSysTestWsdlurl);
		builder.append(" \nmviPreProdWsdlurl=").append(mviPreProdWsdlurl);
		builder.append(" \nmviProdWsdlurl=").append(mviProdWsdlurl);
		
		builder.append("\n]");
		return builder.toString();
	}

	public Boolean getIsMviEnabled() {
		return isMviEnabled;
	}
	public Boolean getIsReloadRequired() {
		return isReloadRequired;
	}

	public Boolean getIsMviMockSearchEnabled() {
		return isMviMockSearchEnabled;
	}
	
	public Boolean getIsMviMockCorrespondingEnabled() {
		return isMviMockCorrespondingEnabled;
	}
	
	public Boolean getIsMviMockSearchByEdipiEnabled() {
	return isMviMockSearchByEdipiEnabled;
	}
	public Boolean getIsMviMockCorrelationEnabled() {
		return isMviMockCorrelationEnabled;
	}
	
	public String getMviEnvType() {
		return mviEnvType;
	}
	
	public String getMviDevWsdlurl() {
		return mviDevWsdlurl;
	}
	public String getMviIntbWsdlurl() {
		return mviIntbWsdlurl;
	}
	public String getMviSysTestWsdlurl() {
		return mviSysTestWsdlurl;
	}

	public String getMviPreProdWsdlurl() {
		return mviPreProdWsdlurl;
	}
	
	public String getMviProdWsdlurl() {
		return mviProdWsdlurl;
	}

	public Integer getMviConnectTimeout() {
		return mviConnectTimeout;
	}

	public Integer getMviRequestTimeout() {
		return mviRequestTimeout;
	}
	public String getMviInteractionId() {
		return mviInteractionId;
	}
	public String getVaOidValue() {
		return vaOidValue;
	}
	public String getMviRootId() {
		return mviRootId;
	}
	public String getMviReceivingFacilityId() {
		return mviReceivingFacilityId;
	}
	public String getMviUsssaIdentifierId() {
		return mviUsssaIdentifierId;
	}
	public String getMviFacilityAssignAuthority() {
		return mviFacilityAssignAuthority;
	}
	public String getMviPatientIdentifier() {
		return mviPatientIdentifier;
	}
	public String getMviNationalIdentifier() {
		return mviNationalIdentifier;
	}
	public String getMviProdDodrootId() {
		return mviProdDodrootId;
	}
	public String getMviNonprodDodrootId() {
		return mviNonprodDodrootId;
	}
	public String getDodAssigningAuthority() {
		return dodAssigningAuthority;
	}
	public String getDodFacilityAssigning() {
		return dodFacilityAssigning;
	}
	
//	public Integer getMviAuthBatchNumberToRun() {
//		return mviAuthBatchNumberToRun;
//	}
//	
//	public Integer getMviUnauthBatchNumberToRun() {
//		return mviUnauthBatchNumberToRun;
//	}
//	
//	public String getMviAuthBatchAdmin() {
//		return mviAuthBatchAdmin;
//	}
//	
//	public Integer getMviAuthBatchIntervalHours() {
//		return mviAuthBatchIntervalHours;
//	}
}
